/*  Ermittelt, ob es sich bei der gegebenen resource_id um ein Kopfkostenstelle handelt.

    Als Language SQL implementiert, damit der Planer das SQL-Statement "inline" in die rufende SQL-Abfrage einfügen kann.
*/
SELECT tsystem.function__drop_by_regex( 'resource__is_top_resource', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource__is_top_resource(
    _resource_id integer
) RETURNS bool AS $$
    SELECT ( count( r_main.id ) > 0 ) AS result
    FROM scheduling.resource AS r_top
    JOIN ksvba AS ksb                                  ON ksb.ksb_id = r_top.context_id
                                                      AND ksb.ksb_ks_ba_num = 1 -- Nur der Arbeitsplatz mit der Nummer 1 wird von der Kopfkostenstelle verwendet.
                                                      AND r_top.context = 'ksvba'
    JOIN scheduling.resource_requirement_option AS rro ON rro.resource_id = r_top.id
    JOIN scheduling.resource_requirement AS rr         ON rr.id = rro.requirement_id
    JOIN scheduling.resource AS r_main                 ON r_main.id = rr.required_by
                                                      AND r_main.context = 'ksvba'
    WHERE r_top.id = _resource_id
$$ LANGUAGE sql STABLE PARALLEL SAFE;
